﻿$(document).on("pageinit", function () {
    var context = $("[data-questiontype='slider'],[data-questiontype='hybridgrid']");

    $(":checkbox", context).each(function () {
        ToggleSlider($(this), true);
    });

    $(":checkbox", context).on("change", function () {
        ToggleSlider($(this));
    });

    $("input[type=number]", context).on("change", function () {
        var parent = $(this).parent();
        $(":checkbox", parent).prop("checked", false).checkboxradio("refresh");
    });
});

function ToggleSlider(checkBox, initialize) {
    var parent = checkBox.parent().parent();
    var input = $("input[type=number]", parent);

    if (checkBox.is(":checked")) {
        input.attr("data-previous", input.val());
        input.val("").slider("disable");
    }
    else if (!initialize) {
        var previousValue = input.attr("data-previous");
        input.val(previousValue).slider("enable").slider("refresh");
    }
}